-- 8_onZoom
    
function setup()
    -- prepare any object with x,y,w,h fields, here a button
    button = {
    x = WIDTH/2,
    y = HEIGHT/2,
    w = WIDTH/4,
    h = HEIGHT/4,
    fontSize = 50,
    txt = "pinch me or zoom me",
    color = color(255, 190, 0, 255), -- button color in false state
    }
    button.deltaWH = function(self,dw,dh)
        local surface = self.w * self.h
        self.w = self.w + dw
        self.h = self.h + dh
        local newSurface = self.w * self.h
        self.fontSize = self.fontSize * math.sqrt( newSurface / surface )
    end
    -- ############### and add a Sensor to it  #################
    button.sensor = Sensor{ parent=button, xywhMode=RADIUS }
    button.sensor:onZoom( function(event)
        button:deltaWH( event.dw, event.dh)
    end)
    -- #########################################################
end
function touched(t)
    -- ######### add this in your touched function #########
    if button.sensor:touched(t) then return true end
end
function draw()
    noStroke()
    background(178, 178, 178, 255)     
    fill(button.color)
    rectMode(RADIUS)
    rect(button.x,button.y,button.w,button.h)
    fill(57, 57, 57, 255)         -- set color for text
    fontSize(button.fontSize)     -- set font size
    textAlign(CENTER)
    textWrapWidth(button.w*1.8)
    text(button.txt,button.x,button.y)       -- draw text on screen)      
end
